/*  This do file creates county-industry data for 1850 comparable to the county-ind data for the other years transcribed and created for RR2

*/

cd "" // your desired directory

local data_1850 = "" // your path to 1850 data

import delimited "`data_1850'", varnames(1) clear

*destring all needed numeric data. Force all unreadable data to missing
foreach var of varlist hands_male hands_female avg_wage_male avg_wage_female production_values* materials_value* capital{
	di "`var'"
	destring `var', replace force
	replace `var' = 0 if `var' == .
}

*Assume labor data reported is a typical month
gen wages = 12*(hands_male*avg_wage_male + hands_female*avg_wage_female)
gen labor = hands_male + hands_female

*Create the rest of the CI variables
egen out = rowtotal(production_values*)
egen material_val = rowtotal(materials_value*)

gen estab = 1

rename capital cap

rename material_val rms
gen year=1850

*Keep what is needed
keep ind_broadest ind_leontief ind_granular ind_detailed cap rms estab out wages labor fips year state 

foreach industry_set in ind_broadest ind_leontief ind_granular ind_detailed {
*Create the separate files based on industry granularity
if inlist("`industry_set'","ind_broadest","ind_leontief") {
	gen class_ind = 1
} 

if inlist("`industry_set'","ind_granular","ind_detailed") {
	gen class_ind = 2
} 
di "here"
foreach outcome in cap rms estab out wages labor {
	egen mfg`outcome' = total(`outcome'), by(fips state year `industry_set')
}

preserve


keep fips year state class_ind mfg* `industry_set'

order  fips year state class_ind `industry_set' mfg* 
duplicates drop

local ind = subinstr("`industry_set'","ind_","",.)
if "`ind'"=="leontief"{
	local ind="Leontief"
}
else if "`ind'"=="broadest"{
	local ind="broad"
}
export delimited "mfg_ind_1850`ind'.csv", replace

restore  

drop mfg* class_ind

}

